%% Network Analysis Code Readme
% Author: Yen-Nan Lin

%% About
% The code was written and tested in MATLAB R2012a. Goal of this package was to
% analyse the difference between neural networks and theoretical networks in
% horizontal and vertical propagations. Because some functions used random
% number generator (most of the functions are module-related), the scripts might
% generate slightly differnet result in different computers. More details were
% shown in the manuscript.
%
% This package include several toolboxes to analyze networks and plot figures.
% The toolboxes are under in the Toolbox folder.
%
% *Network analysis toolbox*
%
% * 2011-03-27_BCT http://sites.google.com/site/bctnet
%
% *Plotting toolboxes*
%
% * xticklabel_rotate http://www.mathworks.com/matlabcentral/fileexchange/3486-xticklabelrotate
% * ploterr http://www.mathworks.com/matlabcentral/fileexchange/22216-ploterr
% * panel_2.4 http://www.mathworks.com/matlabcentral/fileexchange/20003-panel
% * breakYAxis http://www.mathworks.co.uk/matlabcentral/fileexchange/22378-break-y-axis
%

%% Run
%
% The codes could be classified into 2 groups: scripts and functions.
% All goXXXXXXX.m files should be scripts. Below is a process of standard
% analysis. The step of plotting are not included in the standard analysis process.
%
% # load neural network
% # analyse neural network
% # create theoretical networks based on the loaded neural network
% # analyse theoretical networks
% # compute the average of realisation results
% # plot the result
%
% Here is a standard analysis example. In the matlab, and command
%
%   goAnalysis
%
% Then, run specific plotting script based on which figure you want to plot.
%
% If you want to plot result of figure 9, you should run another analysis
% script. However, this scripts may take several hours to compute.
%
%   goAnalysisRecur

%% Script of plotting figures
% * fig3.tif = goPlotChConnectMat.m
% * fig4.tif = goPlotHorzDistr.m
% * fig5a.tif = goPlotVert.m
% * fig5b.tif = goPlotHorz.m
% * fig5c.tif = goPlotSummary.m
% * fig6.tif = goPlotChConnectMatIO.m
% * fig7a.tif = goPlotVertIO.m
% * fig7b.tif = goPlotHorzIO.m
% * fig7c.tif = goPlotSummaryIO.m
% * fig8a.tif = goPlotSwAddHub.m
% * fig8b.tif = goPlotRemoveHub.m
% * fig8c.tif = goPlotRemoveHub.m
% * fig8d.tif = goPlotRemoveHub.m
% * fig9a.tif = goPlotRecur.m
% * fig9b.tif = goPlotNewNode.m
% * fig9c.tif = goPlotNPath.m
% * fig11.tif = goPlotChConnectCE.m


%% More information
%
% The full documents of functions and scripts are shown in
% <doc/index.html>.
%
% The dependencies of functions are shown in
% <doc/NA/graph.html>.
