function [ network ] = bioNetwork( filePath, dataType )
% BIONETWORK load graph matrix from filePath and return a network structure
%
%   [ network ] = bioNetwork( filePath, dataType )
%   This function load graph matrix from filePath and return a network structure
%
%   Input:
%       filePath: path of file which could be txt or mat file
%       dataType: 'normal' = txt file, 'mat' = mat file
%
%   Output:
%       network: a network structure

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

data = [];
if strcmp(dataType, 'normal')
    fileID = fopen(filePath, 'r');
    while ~feof(fileID)
        strLine = fgetl(fileID);
        numericLine = strread(strLine, '%d');
        data = [ data; numericLine' ];
    end
    fclose(fileID);
elseif strcmp(dataType, 'mat')
    matFile = load(filePath);
    data = matFile.graphMatrix;
end
network = struct('data', sparse(data), 'size', length(data(:,1)) );
network = make(network);
end

function [ network ] = make( network )
network.matrix = sparse(network.size, network.size);
network.matrix = network.data;
network.label = 1:(network.size);
end

