function [ ioLevelMatrix, pathNumMatrix ] = computePathNum( network, level )
% COMPUTEPATHNUM compute pathway number of input -> output and whole block.
%
%   [ ioLevelMatrix, pathNumMatrix ] = computePathNum( network, level )
%   This function compute pathway number of input->output block and whole
%   block.
%
%   Input:
%       network: network structure containg 'matrix', 'inputNumber',
%           'outputNumber' field.
%       level: 1 means direct link between nodes. ( = level 0 in manuscript)
%           2 means source -> X -> destination, X is a node.
%           The rest can be done in the same manner.
%
%   Output:
%       ioLevelMatrix: pathway number of input -> output block.
%       pathNumMatrix: pathway number of whole block.
%           Below is oder of each block.
%           -----------------------------------------------
%           | in -> in    | in -> out    | in -> inter    |
%           -----------------------------------------------
%           | out -> in   | out -> out   | out -> inter   |
%           -----------------------------------------------
%           | inter -> in | inter -> out | inter -> inter |
%           -----------------------------------------------

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

CONNECT_MATRIX_FIELD_NAME = 'matrix';
INPUT_NUMBER_FIELD_NAME = 'inputNumber';
OUTPUT_NUMBER_FIELD_NAME = 'outputNumber';
pathNumMatrix = getfield(network, CONNECT_MATRIX_FIELD_NAME);
nInput = getfield(network, INPUT_NUMBER_FIELD_NAME);
nOutput = getfield(network, OUTPUT_NUMBER_FIELD_NAME);
inputIx = 1:nInput;
outputIx = (nInput + 1):(nInput + nOutput);
for iLevel= 1:(level - 1)
    pathNumMatrix = pathNumMatrix * getfield(network, CONNECT_MATRIX_FIELD_NAME);
end
ioLevelMatrix = pathNumMatrix(inputIx, outputIx);
end
