function [ cfitObject, sseError ] = fitGompertz( inputT, acutalOutput )
% FITGOMPERTZ return cfitObject by fitting Gompertz function
%
%   [ cfitObject, sseError ] = fitGompertz( inputT, acutalOutput )
%   Based on inputT and acutalOutput, this function return cfitObject fitting
%   with Gompertz function.
%   Gompertz function: y(t) = a * exp(b * exp(c * t))
%
%   Input:
%       inputT: value of input t
%       acutalOutput: output of input t
%
%   Output:
%       cfitObject: cfit object of fitting result
%       sseError: sum square error of fitting result

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

DEFAULT_PARAMETER = [1 -4 -5];
options = optimset('MaxFunEvals', 1000, 'TolFun',1e-18, 'MaxIter', 1000);
[estimateParameter, sseError] = fminsearch(@sseFitGompertz, ...
    DEFAULT_PARAMETER, options, inputT, acutalOutput);
a = estimateParameter(1);
b = estimateParameter(2);
c = estimateParameter(3);
cfitObject = cfit(fittype('a * exp(b * exp(c * x))'), a, b, c);
end

function [ sumSquareError ] = sseFitGompertz( params, inputT, acutalOutput )
% sum square error of fitting function
a = params(1);
b = params(2);
c = params(3);
fittedGompertz = a * exp(b * exp(c * inputT));
errorVector = fittedGompertz - acutalOutput;
sumSquareError = sum(errorVector.^2);
end
