% This script produces the figure 11. It plot channel connectivity matrix of
% C. Elegans network with highlighted modules in propagation levels 0-3.

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

close all;

NUM_FIG_COL = 4;
FIG_SIZE = [0, 0, 1500, 300];
MAX_PLOT_LEVEL = 4;
REDUCE_COLORBAR_WIDTH = 0.01;

% setting of figure
figure('outerPosition', FIG_SIZE, 'color', 'w');
panelObj = panel();
panelObj.pack(1, NUM_FIG_COL);
panelObj.fontsize = 15;
panelObj.fontname = 'Arial';
panelObj.fontweight = 'bold';
panelObj.margin = [10 15 3 8];
panelObj.de.margin = 3;
panelObj.title('CE Network');
panelObj.ylabel('Input nodes');
panelObj.xlabel('Output nodes');

% plot channel connectivity matrix of C. Elegans
nInput = ceNetwork.inputNumber;
nOutput = ceNetwork.outputNumber;
for iLevel = 1:MAX_PLOT_LEVEL
    panelObj(1, iLevel).select();
    plotOpt.showXTick = true;
    if iLevel == 1
        plotOpt.showYTick = true;
    else
        plotOpt.showYTick = false;
    end
    myImagesc(ceNetwork.ChConnectMat{iLevel}, plotOpt);
    panelObj(1, iLevel).title(['Level ', int2str(iLevel - 1)]);

    % highlight modules
    for jModule = 1:ceNetwork.NumModule
        tmpInputIxList = find(ceNetwork.moduleId(1:nInput) == jModule);
        tmpOutputIxList = find(...
            ceNetwork.moduleId((nInput + 1):(nInput + nOutput)) == jModule);
        if isempty(tmpInputIxList) || isempty(tmpOutputIxList)
            continue;
        end
        xPosition = min(tmpOutputIxList) - 0.5;
        yPosition = min(tmpInputIxList) - 0.5;
        width = numel(tmpOutputIxList);
        height = numel(tmpInputIxList);
        rectangle('position', [xPosition, yPosition, width, height], ...
            'edgeColor', 'w', 'lineWidth', 4);
    end
end
