% This script produces the figure 3. It shows channel connectivity matrixes
% of several networks (C. Elegans neural network, small-world network,
% random network, Drosophila's CX network) in propagation level 0-3.

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

close all;

NUM_FIG_ROW = 4;
NUM_FIG_COL = 4;
FIG_SIZE = [0, 0, 1500, 1000];
MAX_PLOT_LEVEL = 4;
REDUCE_COLORBAR_WIDTH = 0.01;

% setting of figure
figure('outerPosition', FIG_SIZE, 'color', 'w');
panelObj = panel();
panelObj.pack('v', [7/8, -1], 'h', [1/25, -1]);
panelObj(1, 2).pack(NUM_FIG_ROW - 1, NUM_FIG_COL);
panelObj(2, 2).pack(1, NUM_FIG_COL);
panelObj(1, 1).pack(NUM_FIG_ROW - 1, 1);
panelObj(2, 1).pack(1);
panelObj.fontsize = 15;
panelObj.fontname = 'Arial';
panelObj.fontweight = 'bold';
panelObj.margin = [10 15 3 8];
panelObj.de.margin = 3;

% plot C. Elegans neural network
for iLevel = 1:MAX_PLOT_LEVEL
    panelObj(1, 2, 1, iLevel).select();
    plotOpt.showXTick = false;
    if iLevel == 1
        plotOpt.showYTick = true;
    else
        plotOpt.showYTick = false;
    end
    myImagesc(ceNetwork.ChConnectMat{iLevel}, plotOpt);
    title(['Level ', int2str(iLevel - 1)]);
end
panelObj(1, 1, 1).ylabel('CE');

% plot small-world neural network
for iLevel = 1:MAX_PLOT_LEVEL
    panelObj(1, 2, 2, iLevel).select();
    plotOpt.showXTick = false;
    if iLevel == 1
        plotOpt.showYTick = true;
    else
        plotOpt.showYTick = false;
    end
    myImagesc(smallRingNet{1}.ChConnectMat{iLevel}, plotOpt);
end
panelObj(1, 1, 2).ylabel('SW');

% plot random network
for iLevel = 1:MAX_PLOT_LEVEL
    panelObj(1, 2, 3, iLevel).select();
    plotOpt.showXTick = true;
    if iLevel == 1
        plotOpt.showYTick = true;
    else
        plotOpt.showYTick = false;
    end
    myImagesc(randNetwork{1}.ChConnectMat{iLevel}, plotOpt);
end
panelObj(1, 1, 3).ylabel('ER');

% plot Drosophila's PCB network
for iLevel = 1:MAX_PLOT_LEVEL
    panelObj(2, 2, 1, iLevel).select();
    plotOpt.showXTick = true;
    if iLevel == 1
        plotOpt.showYTick = true;
    else
        plotOpt.showYTick = false;
    end
    myImagesc(cxNetwork.ChConnectMat{iLevel}, plotOpt);
end
panelObj(2, 1).ylabel('CX');

panelObj(2, 2).xlabel('Output nodes');
panelObj(1, 2).ylabel('Input nodes');