% This script produces the figure 6. It shows channel connectivity matrixes
% of changing input-output C. Elegans and small-world networks (ditant I/O SW,
% rand I/O CE, separated I/O CE, reverse I/O CE) in propagation level 0-3.

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

close all;

NUM_FIG_ROW = 4;
NUM_FIG_COL = 4;
FIG_SIZE = [0, 0, 1500, 1000];
MAX_PLOT_LEVEL = 4;
REDUCE_COLORBAR_WIDTH = 0.01;

% setting of figure
figure('outerPosition', FIG_SIZE, 'color', 'w');
panelObj = panel();
panelObj.pack('v', [7/9, -1], 'h', [1/25, -1]);
panelObj(1, 2).pack(NUM_FIG_ROW - 1, NUM_FIG_COL);
panelObj(2, 2).pack(1, NUM_FIG_COL);
panelObj(1, 1).pack(NUM_FIG_ROW - 1, 1);
panelObj(2, 1).pack(1);
panelObj.fontsize = 15;
panelObj.fontname = 'Arial';
panelObj.fontweight = 'bold';
panelObj.margin = [10 15 3 8];
panelObj.de.margin = 6;

% plot distant IO SW networks
for iLevel = 1:MAX_PLOT_LEVEL
    panelObj(1, 2, 1, iLevel).select();
    plotOpt.showXTick = false;
    if iLevel == 1
        plotOpt.showYTick = true;
    else
        plotOpt.showYTick = false;
    end
    myImagesc(smallRingDistNet{1}.ChConnectMat{iLevel}, plotOpt);
    title(['Level ', int2str(iLevel - 1)]);
end
panelObj(1, 1, 1).ylabel('Distant I/O SW');

% plot random IO CE networks
for iLevel = 1:MAX_PLOT_LEVEL
    panelObj(1, 2, 2, iLevel).select();
    plotOpt.showXTick = false;
    if iLevel == 1
        plotOpt.showYTick = true;
    else
        plotOpt.showYTick = false;
    end
    myImagesc(randIoCeNet{1}.ChConnectMat{iLevel}, plotOpt);
end
panelObj(1, 1, 2).ylabel('Rand I/O CE');

% plot separated IO CE networks
for iLevel = 1:MAX_PLOT_LEVEL
    panelObj(1, 2, 3, iLevel).select();
    plotOpt.showXTick = true;
    if iLevel == 1
        plotOpt.showYTick = true;
    else
        plotOpt.showYTick = false;
    end
    myImagesc(sepIoCeNet{1}.ChConnectMat{iLevel}, plotOpt);
end
panelObj(1, 1, 3).ylabel('Separated I/O CE');

% plot reverse IO CE networks
for iLevel = 1:MAX_PLOT_LEVEL
    panelObj(2, 2, 1, iLevel).select();
    plotOpt.showXTick = true;
    if iLevel == 1
        plotOpt.showYTick = true;
    else
        plotOpt.showYTick = false;
    end
    myImagesc(revIoCeNet.ChConnectMat{iLevel}, plotOpt);
end
panelObj(2, 1).ylabel('Reversed I/O CE');

panelObj(2, 2).xlabel('Output nodes');
panelObj(1, 2).ylabel('Input nodes');