% This script produces the figure 7b. It plot the horizontal propagation versus
% propagation levels in C. Elegans network, rand IO CE networks, separated IO
% CE networks, reversed IO CE network, small-world network, distant IO SW
% network. The curves are based on fitting Gompertz function. The errorbar is
% standard deviation.

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

close all;

% plot setting
FIG_SIZE = [0 0 1200 600];
lineWidth = 3;
markerSize = 10;
markerScaleL = 1.5;
markerScaleS = 1.2;

% fitting with Gompertz function
cfit.CE = fitGompertz(0:(MAX_LEVEL - 1), ceNetwork.HorzProp);
cfit.RingDist = fitGompertz(0:(MAX_LEVEL - 1), meanRingDistNet.HorzProp);
cfit.Ring = fitGompertz(0:(MAX_LEVEL - 1), meanRingNet.HorzProp);
cfit.RandIoCE = fitGompertz(0:(MAX_LEVEL - 1), meanRandIoCeNet.HorzProp);
cfit.SepIoCE = fitGompertz(0:(MAX_LEVEL - 1), meanSepIoCeNet.HorzProp);
cfit.RevIoCe = fitGompertz(0:(MAX_LEVEL - 1), revIoCeNet.HorzProp);

% save cfit object to each network
ceNetwork.cfitHorzProp = cfit.CE;
meanRingDistNet.cfitHorzProp = cfit.RingDist;
meanRingNet.cfitHorzProp = cfit.Ring;
meanRandIoCeNet.cfitHorzProp = cfit.RandIoCE;
meanSepIoCeNet.cfitHorzProp = cfit.SepIoCE;
revIoCeNet.cfitHorzProp = cfit.RevIoCe;

% plot marker and errorbar of each networks
figure('name', 'Horizontal Propagation', 'outerPosition', FIG_SIZE, 'color', 'w');
hold on;
tmpP = linspace(0, MAX_LEVEL - 1, 100);
plot(0:(MAX_LEVEL - 1), ceNetwork.HorzProp, 'Marker', netMarker('CE'), ...
    'Color', netColor('CE'), 'MarkerSize', markerSize, ...
    'MarkerFaceColor', netMarkerFace('CE'), ...
    'LineWidth', lineWidth, 'LineStyle', 'none');
errorbar(0:(MAX_LEVEL - 1), meanRandIoCeNet.HorzProp, ...
    stdRandIoCeNet.HorzProp, 'Marker', netMarker('RandIoCE'), ...
    'Color', netColor('RandIoCE'), 'MarkerSize', markerSize * markerScaleS, ...
    'MarkerFaceColor', netMarkerFace('RandIoCE'), ...
    'LineWidth', lineWidth, 'LineStyle', 'none');
errorbar(0:(MAX_LEVEL - 1), meanSepIoCeNet.HorzProp, ...
    stdSepIoCeNet.HorzProp, 'Marker', netMarker('SepIoCE'), ...
    'Color', netColor('SepIoCE'), 'MarkerSize', markerSize * markerScaleL, ...
    'MarkerFaceColor', netMarkerFace('SepIoCE'), ...
    'LineWidth', lineWidth, 'LineStyle', 'none');
plot(0:(MAX_LEVEL - 1), revIoCeNet.HorzProp, ...
    'Marker', netMarker('RevIoCE'), 'Color', netColor('RevIoCE'), ...
    'MarkerSize', markerSize * markerScaleS, ...
    'MarkerFaceColor', netMarkerFace('RevIoCE'), ...
    'LineWidth', lineWidth, 'LineStyle', 'none');
errorbar(0:(MAX_LEVEL - 1), meanRingNet.HorzProp, stdRingNet.HorzProp, ...
    'Marker', netMarker('SW'), 'Color', netColor('SW'), ...
    'MarkerSize', markerSize, 'MarkerFaceColor', netMarkerFace('SW'), ...
    'LineWidth', lineWidth, 'LineStyle', 'none');
errorbar(0:(MAX_LEVEL - 1), meanRingDistNet.HorzProp, ...
    stdRingDistNet.HorzProp, 'Marker', netMarker('DistSW'), ...
    'Color', netColor('DistSW'), 'MarkerSize', markerSize, ...
    'MarkerFaceColor', netMarkerFace('DistSW'), 'LineWidth', lineWidth, ...
    'LineStyle', 'none');

% plot fitting curve of each network
plot(tmpP, cfit.CE(tmpP), 'Color', netColor('CE'), 'LineWidth', 4);
plot(tmpP, cfit.RandIoCE(tmpP), 'Color', netColor('RandIoCE'), 'LineWidth', 4);
plot(tmpP, cfit.SepIoCE(tmpP), 'Color', netColor('SepIoCE'), 'LineWidth', 4);
plot(tmpP, cfit.RevIoCe(tmpP), 'Color', netColor('RevIoCE'), 'LineWidth', 4);
plot(tmpP, cfit.Ring(tmpP), 'Color', netColor('SW'), 'LineWidth', 4);
plot(tmpP, cfit.RingDist(tmpP), 'Color', netColor('DistSW'), 'LineWidth', 4);
plot([2 2], [0 ceNetwork.cfitHorzProp(2)], '--k', 'lineWidth', 3);
set(gca, 'FontSize', 18, 'lineWidth', 4, 'FontWeight', 'bold');

xlim([0 4]);
ylim([0 1.1]);
xlabel('Propagation level');
ylabel('Horizontal propagation');
set(gca, 'xTick', [0 1 2 3 4], 'yTick', [0 0.4 0.8 1]);
box off;