% This script produces the figure 9c. It plot the log10(number of pathways)
% versus propagation levels in C. Elegans neural network, small-world network,
% random network and Drosophila's CX network.

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

close all;

% plot setting
FIG_SIZE = [0 0 1200 600];
lineWidth = 3;
markerSize = 10;
markerScale = 1.5;

figure('name', 'nPath vs level', 'outerPosition', FIG_SIZE, 'color', 'w');
hold on;
% C. Elegans
tmpNPath = cellfun(@(x) mean(x(:)), ceNetwork.LevelMatrix);
plot(0:7, tmpNPath, 'lineWidth', lineWidth, 'marker', netMarker('CE'), ...
    'color', netColor('CE'), 'markerFace', netMarkerFace('CE'), ...
    'markerSize', markerSize);

% Central complex
tmpNPath = cellfun(@(x) mean(x(:)), cxNetwork.LevelMatrix);
plot(0:7, tmpNPath, 'lineWidth', lineWidth, 'marker', netMarker('CX'), ...
    'color', netColor('CX'), 'markerFace', netMarkerFace('CX'), ...
    'markerSize', markerSize * markerScale);

% Small-world network
tmpNPathList = zeros(REPEAT_TIMES, MAX_LEVEL);
for iNet = 1:REPEAT_TIMES
    tmpNPathList(iNet, :) = ...
        cellfun(@(x) mean(x(:)), smallRingNet{iNet}.LevelMatrix);
end
plot(0:7, mean(tmpNPathList, 1), 'lineWidth', lineWidth, ...
    'color', netColor('SW'), 'marker', netMarker('SW'), ...
    'markerFace', netMarkerFace('SW'), 'markerSize', markerSize);

% Random network
tmpNPathList = zeros(REPEAT_TIMES, MAX_LEVEL);
for iNet = 1:REPEAT_TIMES
    tmpNPathList(iNet, :) = ...
        cellfun(@(x) mean(x(:)), randNetwork{iNet}.LevelMatrix);
end
plot(0:7, mean(tmpNPathList, 1), 'lineWidth', lineWidth, ...
    'color', netColor('ER'), 'marker', netMarker('ER'), ...
    'markerFace', netMarkerFace('ER'), 'markerSize', markerSize * markerScale);
hold off;

set(gca, 'yScale', 'log', 'FontName', 'Arial', ...
    'FontSize', 18, 'lineWidth', 4, 'FontWeight', 'bold');
xlabel('Propagation level');
ylabel('Number of pathways');
hL = legend('CE', 'CX', 'SW', 'ER', 'location', 'SouthEast');
set(hL, 'box', 'off');
box off;