% This script create the figure 9a. It plot the channel connectivity matrixes
% and number of new nodes of C. Elegans and random networks in level 1, 3, 5, 7.

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

close all;

NUM_FIG_ROW = 4;
NUM_FIG_COL = 4;
FIG_SIZE = [0, 0, 1200, 630];
NUM_PLOT_LEVEL = 4;
REDUCE_COLORBAR_WIDTH = 0.01;
PLOT_LEVELS = [2, 4, 6, 8];

% setting of figure
figure('outerPosition', FIG_SIZE, 'color', 'w');
panelObj = panel();
panelObj.pack('h', [1/12, -1]);
panelObj(1).pack(2);
panelObj(2).pack(NUM_FIG_ROW, NUM_FIG_COL);
panelObj.fontsize = 15;
panelObj.fontname = 'Arial';
panelObj.fontweight = 'bold';
panelObj.margin = [3 15 3 8];
panelObj.de.margin = 3;
panelObj(1, 2).margin = [3, 3, 3, 10];
panelObj(2, 2).margin = [3, 5, 3, 3];
panelObj(2, 3).margin = [3, 3, 3, 5];
panelObj(2).xlabel('Output nodes');

% Random network
panelObj(1, 1).select();
title('Random');
axis off;
% channel connectivity matrix
for iLevel = 1:NUM_PLOT_LEVEL
    panelObj(2, 1, iLevel).select();
    plotOpt.showXTick = false;
    if iLevel == 1
        plotOpt.showYTick = true;
    else
        plotOpt.showYTick = false;
    end
    plotLv = PLOT_LEVELS(iLevel);
    myImagesc(randNetwork{1}.ChConnectMat{plotLv}, plotOpt);
    title(['Level ', int2str(plotLv - 1)]);
end
panelObj(2, 1).ylabel(sprintf('Channel\nconnectivity'));
% number of new nodes
for iLevel = 1:NUM_PLOT_LEVEL
    panelObj(2, 2, iLevel).select();
    plotOpt.showXTick = false;
    if iLevel == 1
        plotOpt.showYTick = true;
        ylabel('Input nodes');
    else
        plotOpt.showYTick = false;
    end
    plotLv = PLOT_LEVELS(iLevel);
    myImagesc(randNetwork{1}.NumNewNodeMat{plotLv}, plotOpt);
end
panelObj(2, 2).ylabel(sprintf('New\nnodes'));

% C. Elegans
panelObj(1, 2).select();
title('C. Elegans');
axis off;
% channel connectivity matrix
for iLevel = 1:NUM_PLOT_LEVEL
    panelObj(2, 3, iLevel).select();
    plotOpt.showXTick = false;
    if iLevel == 1
        plotOpt.showYTick = true;
    else
        plotOpt.showYTick = false;
    end
    plotLv = PLOT_LEVELS(iLevel);
    myImagesc(ceNetwork.ChConnectMat{plotLv}, plotOpt);
end
panelObj(2, 3).ylabel(sprintf('Channel\nconnectivity'));
% number of new nodes
for iLevel = 1:NUM_PLOT_LEVEL
    panelObj(2, 4, iLevel).select();
    plotOpt.showXTick = false;
    if iLevel == 1
        plotOpt.showYTick = true;
        ylabel('Input nodes');
    else
        plotOpt.showYTick = false;
    end
    plotLv = PLOT_LEVELS(iLevel);
    myImagesc(ceNetwork.NumNewNodeMat{plotLv}, plotOpt);
end
panelObj(2, 4).ylabel(sprintf('New\nnodes'));
