% This script generate figure 8b, 8c and 8d. This script in not only a plotting
% script but also an anlaysis script. It contain the process of removing hubs
% of C. Elegnas, central complex and kinless hubs small-world networks, so it
% may take several minutes to analyse and plot vertical versus horizontal
% propagation in level 2.

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

close all;

% setting of analysis
nRmHub = 15;
nRmHubCX = 10;
REPEAT_TIMES = 100;
REWIRE_PROB_RING = 0.3;

% setting of figure
xErrBarWidth = 0.015;
yErrBarWidth = 0.025;
FIG_SIZE = [0 0 600 650];
textSize = 16;
lineWidth = 3;
markerSize = 10;
markerScale = 1.5;

% Remove hubs of C. Elegnas networks
nNode = ceNetwork.size;
nInput = ceNetwork.inputNumber;
nOutput = ceNetwork.outputNumber;
nInter = ceNetwork.size - nInput - nOutput;
nEdge = mean(sum(ceNetwork.matrix));

tmpRmNet = ceNetwork;
rmHubHorzCE = zeros(1, nRmHub);
rmHubVertCE = zeros(1, nRmHub);
parCoefCE = participateCoef(tmpRmNet);
rmParCoefCE = zeros(1, nRmHub);

tmpInOutDeg = sum(tmpRmNet.matrix, 1)' + sum(tmpRmNet.matrix, 2);
[tmpSort, tmpSortIx] = sort(tmpInOutDeg, 'descend');
tmpSortLabel = tmpRmNet.label(tmpSortIx);
for iNode = 1:nRmHub
    tmpLabel = tmpSortLabel(iNode);
    rmIx = find(tmpRmNet.label == tmpLabel, 1);
    tmpRmNet = rmNode(tmpRmNet, rmIx);
    rmParCoefCE(iNode) = parCoefCE(tmpSortIx(iNode));

    tmpRmNet = levelAnalysis(tmpRmNet, MAX_LEVEL);
    rmHubVertCE(iNode) = tmpRmNet.VertProp(3);
    rmHubHorzCE(iNode) = tmpRmNet.HorzProp(3);
end

% Remove hubs of central complex networks
tmpRmNet = cxNetwork;
rmHubHorzCX = zeros(1, nRmHubCX);
rmHubVertCX = zeros(1, nRmHubCX);
parCoefCX = participateCoef(tmpRmNet);
rmParCoefCX = zeros(1, nRmHubCX);

tmpInOutDeg = sum(tmpRmNet.matrix, 1)' + sum(tmpRmNet.matrix, 2);
[tmpSort, tmpSortIx] = sort(tmpInOutDeg, 'descend');
tmpSortLabel = tmpRmNet.label(tmpSortIx);
for iNode = 1:nRmHubCX
    tmpLabel = tmpSortLabel(iNode);
    rmIx = find(tmpRmNet.label == tmpLabel, 1);
    tmpRmNet = rmNode(tmpRmNet, rmIx);
    rmParCoefCX(iNode) = parCoefCX(tmpSortIx(iNode));

    tmpRmNet = levelAnalysis(tmpRmNet, MAX_LEVEL);
    rmHubVertCX(iNode) = tmpRmNet.VertProp(3);
    rmHubHorzCX(iNode) = tmpRmNet.HorzProp(3);
end

% Remove hubs of kinless small-world networks
clear rmHubSwNet meanRmHubSwNet
for iTime = 1:REPEAT_TIMES
    seedNumber = iTime * STRIDE_SEED_NUMBER;
    rmHubSwNet{iTime} = ...
        smallHubNetwork(nNode, REWIRE_PROB_RING, seedNumber, ...
            nEdge, nRmHub, 'kinless');
    rmHubSwNet{iTime} = setIO(rmHubSwNet{iTime}, ceNetwork.inputNumber, ...
        ceNetwork.outputNumber);
    rmHubSwNet{iTime} = levelAnalysis(rmHubSwNet{iTime}, MAX_LEVEL);

    tmpInOutDeg = sum(rmHubSwNet{iTime}.matrix, 1)' + ...
        sum(rmHubSwNet{iTime}.matrix, 2);
    [tmpSort, tmpSortIx] = sort(tmpInOutDeg, 'descend');
    tmpSortLabel = rmHubSwNet{iTime}.label(tmpSortIx);
    rmHubSwNet{iTime}.HubList = tmpSortIx(1:nRmHub);

    % participation coefficient
    rmHubSwNet{iTime}.PartpCoef = participateCoef(rmHubSwNet{iTime});
    tmpRmNet = rmHubSwNet{iTime};
    for jNode = 1:nRmHub
        tmpLabel = tmpSortLabel(jNode);
        rmIx = find(tmpRmNet.label == tmpLabel, 1);
        tmpRmNet = rmNode(tmpRmNet, rmIx);

        tmpRmNet = levelAnalysis(tmpRmNet, MAX_LEVEL);
        rmHubSwNet{iTime}.RmHubVertProp(jNode) = tmpRmNet.VertProp(3);
        rmHubSwNet{iTime}.RmHubHorzProp(jNode) = tmpRmNet.HorzProp(3);
    end
end
% compute mean and std of removed hubs kinless SW networks
meanRmHubSwNet = meanFieldInCells(rmHubSwNet);
tmpHorz = cellfun(@(x) x.HorzProp(3), rmHubSwNet);
tmpVert = cellfun(@(x) x.VertProp(3), rmHubSwNet);
meanRmHubSwNet.StdHorzProp = std(tmpHorz);
meanRmHubSwNet.StdVertProp = std(tmpVert);
for jNode = 1:nRmHub
    tmpVert = cellfun(@(x) x.RmHubVertProp(jNode), rmHubSwNet);
    tmpHorz = cellfun(@(x) x.RmHubHorzProp(jNode), rmHubSwNet);
    meanRmHubSwNet.StdRmHubVertProp(jNode) = std(tmpVert);
    meanRmHubSwNet.StdRmHubHorzProp(jNode) = std(tmpHorz);
end

% plot vertical vs horizontal propagaiton of original networks
figure('name', 'summary', 'outerPosition', FIG_SIZE, 'color', 'w');
hold on;
plot(ceNetwork.HorzProp(3), ceNetwork.VertProp(3), ...
    'Marker', netMarker('CE'), 'Color', netColor('CE'), ...
    'MarkerFaceColor', netMarkerFace('CE'), ...
    'MarkerSize', markerSize, 'LineWidth', lineWidth);
plot(cxNetwork.HorzProp(3), cxNetwork.VertProp(3), ...
    'Marker', netMarker('CX'), 'Color', netColor('CX'), ...
    'MarkerFaceColor', netMarkerFace('CX'), ...
    'MarkerSize', markerSize * markerScale, 'LineWidth', lineWidth);
plot(meanRandNet.HorzProp(3), meanRandNet.VertProp(3), ...
    'Marker', netMarker('ER'), 'Color', netColor('ER'), ...
    'MarkerFaceColor', netMarkerFace('ER'), ...
    'MarkerSize', markerSize * markerScale, 'LineWidth', lineWidth);
plot(meanRegularNet.HorzProp(3), meanRegularNet.VertProp(3), ...
    'Marker', netMarker('RL'), 'Color', netColor('RL'), ...
    'MarkerFaceColor', netMarkerFace('RL'), ...
    'MarkerSize', markerSize, 'LineWidth', lineWidth);
plot(meanRingNet.HorzProp(3), meanRingNet.VertProp(3), ...
    'Marker', netMarker('SW'), 'Color', netColor('SW'), ...
    'MarkerFaceColor', netMarkerFace('SW'), ...
    'MarkerSize', markerSize, 'LineWidth', lineWidth);
plot(meanRmHubSwNet.HorzProp(3), meanRmHubSwNet.VertProp(3), ...
    'Marker', netMarker('Kinless'), 'Color', netColor('Kinless'), ...
    'MarkerFaceColor', netMarkerFace('Kinless'), ...
    'MarkerSize', markerSize, 'LineWidth', lineWidth);
set(gca, 'FontSize', 18, 'lineWidth', 4, 'FontWeight', 'bold');
xlabel('Horizontal propagation');
ylabel('Vertical propagation');
box off;
hold off;

% plot errorbar of ER, RL ans SW networks
hold on;
tmpHorz = cellfun(@(x) x.HorzProp(3), randNetwork);
tmpVert = cellfun(@(x) x.VertProp(3), randNetwork);
hErr = ploterr(mean(tmpHorz), mean(tmpVert), std(tmpHorz), std(tmpVert), ...
    'abshhx', xErrBarWidth, 'abshhy', yErrBarWidth);
set(hErr, 'lineWidth', 2, 'Color', netColor('ER'));

tmpHorz = cellfun(@(x) x.HorzProp(3), regularRingNet);
tmpVert = cellfun(@(x) x.VertProp(3), regularRingNet);
hErr = ploterr(mean(tmpHorz), mean(tmpVert), std(tmpHorz), std(tmpVert), ...
    'abshhx', xErrBarWidth, 'abshhy', yErrBarWidth);
set(hErr, 'lineWidth', 2, 'Color', netColor('RL'));

tmpHorz = cellfun(@(x) x.HorzProp(3), smallRingNet);
tmpVert = cellfun(@(x) x.VertProp(3), smallRingNet);
hErr = ploterr(mean(tmpHorz), mean(tmpVert), std(tmpHorz), std(tmpVert), ...
    'abshhx', xErrBarWidth, 'abshhy', yErrBarWidth);
set(hErr, 'lineWidth', 2, 'Color', netColor('SW'));
hold off;

% plot removed hubs networks
hold on;
plot(rmHubHorzCE, rmHubVertCE, ...
    'Marker', netMarker('CE'), 'Color', netColor('CE'), ...
    'MarkerFaceColor', netMarkerFace('CE'), ...
    'MarkerSize', markerSize - 2, 'LineWidth', lineWidth - 1);
plot(rmHubHorzCE, rmHubVertCE, '--', 'Color', netColor('CE'), 'LineWidth', 2);

plot(rmHubHorzCX, rmHubVertCX, ...
    'Marker', netMarker('CX'), 'Color', netColor('CX'), ...
    'MarkerFaceColor', netMarkerFace('CX'), ...
    'MarkerSize', markerSize * markerScale - 2, 'LineWidth', lineWidth - 1);
plot(rmHubHorzCX, rmHubVertCX, '--', 'Color', netColor('CX'), 'LineWidth', 2);

plot(meanRmHubSwNet.RmHubHorzProp, meanRmHubSwNet.RmHubVertProp, ...
    'Marker', netMarker('Kinless'), 'Color', netColor('Kinless'), ...
    'MarkerFaceColor', netMarkerFace('Kinless'), ...
    'MarkerSize', markerSize - 2, 'LineWidth', lineWidth - 1);
tmpHorz = [meanRmHubSwNet.HorzProp(3), meanRmHubSwNet.RmHubHorzProp];
tmpVert = [meanRmHubSwNet.VertProp(3), meanRmHubSwNet.RmHubVertProp];
plot(tmpHorz, tmpVert, '--', 'lineWidth', 2, 'Color', netColor('Kinless'));

hErr = ploterr(meanRmHubSwNet.HorzProp(3), meanRmHubSwNet.VertProp(3), ...
    meanRmHubSwNet.StdHorzProp, meanRmHubSwNet.StdVertProp, ...
    'abshhx', xErrBarWidth, 'abshhy', yErrBarWidth);
set(hErr, 'lineWidth', 2, 'Color', netColor('Kinless'));

hErr = ploterr(meanRmHubSwNet.RmHubHorzProp, meanRmHubSwNet.RmHubVertProp, ...
    meanRmHubSwNet.StdRmHubHorzProp, meanRmHubSwNet.StdRmHubVertProp, ...
    'abshhx', xErrBarWidth, 'abshhy', yErrBarWidth);
set(hErr, 'lineWidth', 2, 'Color', netColor('Kinless'));
hold off;

% annotation
text(double(ceNetwork.HorzProp(3)), double(ceNetwork.VertProp(3) + 0.02), ...
    '   CE', 'FontSize', textSize, 'FontWeight', 'bold');
text(double(cxNetwork.HorzProp(3)), double(cxNetwork.VertProp(3)), ...
    '   CX', 'FontSize', textSize, 'FontWeight', 'bold');
text(double(meanRandNet.HorzProp(3)), double(meanRandNet.VertProp(3)), ...
    '   ER', 'FontSize', textSize, 'FontWeight', 'bold');
text(double(meanRegularNet.HorzProp(3)), double(meanRegularNet.VertProp(3)), ...
    '   RL', 'FontSize', textSize, 'FontWeight', 'bold');
text(double(meanRingNet.HorzProp(3)), double(meanRingNet.VertProp(3)), ...
    'SW   ', 'FontSize', textSize, 'FontWeight', 'bold', ...
    'HorizontalAlignment', 'right');
text(double(meanRmHubSwNet.HorzProp(3)), double(meanRmHubSwNet.VertProp(3)), ...
    '   Kinless', 'FontSize', textSize, 'FontWeight', 'bold');
hT = text(double(rmHubHorzCE(7)), double(rmHubVertCE(7) + 0.065), ...
    'removing hubs', 'FontSize', textSize - 2, 'FontWeight', 'bold', ...
    'HorizontalAlignment', 'center', 'VerticalAlignment', 'bottom');
ext = get(hT, 'extent');
annotation('arrow', [ext(1) + ext(3), ext(1) + 0.05], [ext(2) - 2.5 * ext(4), ext(2)- 2.5 * ext(4)]);
hT = text(double(meanRmHubSwNet.RmHubHorzProp(9)), double(meanRmHubSwNet.RmHubVertProp(9) - 0.08), ...
    'removing hubs', 'FontSize', textSize - 2, 'FontWeight', 'bold', ...
    'HorizontalAlignment', 'center', 'VerticalAlignment', 'top');
ext = get(hT, 'extent');
annotation('arrow', [ext(1) + ext(3), ext(1) + 0.05], [ext(2) - 0.1, ext(2) - 0.1]);
breakYaxis(2);
set(gca, 'xtick', 0:0.2:1);

% plot participation coefficient of C. Elegans hubs
figure('color', 'w', 'outerPosition', [0 0 850 600], 'name', 'C. Elegnas');
hA = axes('Position',[0 0 1 1],'Visible','off');
axes('Position',[.1 .15 .7 .7]);
plot(1:nRmHub, rmParCoefCE, '.r', 'markerSize', 30, 'lineWidth', 2);
ylim([0 1]);
hold on;
h = plot([0, nRmHub], [0.3, 0.3], '--k', ...
    [0, nRmHub], [0.75, 0.75], '--k');
set(h, 'lineWidth', 2);
set(gca, 'FontSize', 18, 'lineWidth', 2, 'FontWeight', 'bold');
xlabel('Removed hub id');
ylabel('Participation coefficient');
box off;
set(gcf,'CurrentAxes',hA);
text(0.82, .75, 'Kinless', 'fontSize', 18, 'fontWeight', 'bold');
text(0.82, .5, 'Connector', 'fontSize', 18, 'fontWeight', 'bold');
text(0.82, .25, 'Provincial', 'fontSize', 18, 'fontWeight', 'bold');
box off;
hold off;

% plot participation coefficient of central complex hubs
figure('color', 'w', 'outerPosition', [0 0 850 600], 'name', 'Central complex');
hA = axes('Position',[0 0 1 1],'Visible','off');
axes('Position',[.1 .15 .7 .7]);
plot(1:nRmHubCX, rmParCoefCX, '.r', 'markerSize', 30, 'lineWidth', 2);
ylim([0 1]);
hold on;
h = plot([0, nRmHubCX], [0.3, 0.3], '--k', ...
    [0, nRmHubCX], [0.75, 0.75], '--k');
set(h, 'lineWidth', 2);
set(gca, 'FontSize', 18, 'lineWidth', 2, 'FontWeight', 'bold');
xlabel('Removed hub id');
ylabel('Participation coefficient');
box off;
set(gcf,'CurrentAxes',hA);
text(0.82, .75, 'Kinless', 'fontSize', 18, 'fontWeight', 'bold');
text(0.82, .5, 'Connector', 'fontSize', 18, 'fontWeight', 'bold');
text(0.82, .25, 'Provincial', 'fontSize', 18, 'fontWeight', 'bold');
box off;
hold off;