% This script produces the figure 5c. It plot the vertical propagation versus
% horizontal propagation of C. Elegans neural network, small-world network,
% random network, regular network and Drosophila's CX network in level 2.
% The errorbar is standard deviation.

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

close all;

% plot setting
xErrBarWidth = 0.015;
yErrBarWidth = 0.015;
textSize = 16;
lineWidth = 3;
markerSize = 10;
markerScale = 1.5;

FIG_SIZE = [0 0 600 650];
figure('name', 'summary', 'outerPosition', FIG_SIZE, 'color', 'w');

% plot marker of CE, ER, RL, SW and CX networks
hold on;
plot(ceNetwork.HorzProp(3), ceNetwork.VertProp(3), ...
    'Marker', netMarker('CE'), 'Color', netColor('CE'), ...
    'MarkerFaceColor', netMarkerFace('CE'), ...
    'MarkerSize', markerSize, 'LineWidth', lineWidth);
plot(meanRandNet.HorzProp(3), meanRandNet.VertProp(3), ...
    'Marker', netMarker('ER'), 'Color', netColor('ER'), ...
    'MarkerFaceColor', netMarkerFace('ER'), ...
    'MarkerSize', markerSize * markerScale, 'LineWidth', lineWidth);
plot(meanRegularNet.HorzProp(3), meanRegularNet.VertProp(3), ...
    'Marker', netMarker('RL'), 'Color', netColor('RL'), ...
    'MarkerFaceColor', netMarkerFace('RL'), ...
    'MarkerSize', markerSize, 'LineWidth', lineWidth);
plot(meanRingNet.HorzProp(3), meanRingNet.VertProp(3), ...
    'Marker', netMarker('SW'), 'Color', netColor('SW'), ...
    'MarkerFaceColor', netMarkerFace('SW'), ...
    'MarkerSize', markerSize, 'LineWidth', lineWidth);
plot(cxNetwork.HorzProp(3), cxNetwork.VertProp(3), ...
    'Marker', netMarker('CX'), 'Color', netColor('CX'), ...
    'MarkerFaceColor', netMarkerFace('CX'), ...
    'MarkerSize', markerSize * markerScale, 'LineWidth', lineWidth);
set(gca, 'FontSize', 18, 'lineWidth', 4, 'FontWeight', 'bold');
xlabel('Horizontal propagation');
ylabel('Vertical propagation');
box off;

% plot marker and errorbar of small-world networks with rewiring probability
% from 0.01 to 0.5 (defined in goAnalysis.m 'REWIRE')
hold on;
for iNet = 1:numel(meanSmallNet)
    plot(meanSmallNet{iNet}.HorzProp(3), meanSmallNet{iNet}.VertProp(3), ...
        'Marker', netMarker('SW'), 'Color', netColor('SW'), ...
        'MarkerFaceColor', netMarkerFace('SW'), 'MarkerSize', markerSize - 4);

    hErr = ploterr(meanSmallNet{iNet}.HorzProp(3), ...
        meanSmallNet{iNet}.VertProp(3), ...
        stdSmallNet{iNet}.HorzProp(3), ...
        stdSmallNet{iNet}.VertProp(3), ...
        'abshhx', xErrBarWidth, 'abshhy', yErrBarWidth);
    set(hErr, 'lineWidth', 2, 'Color', netColor('SW'));
end
hold off;

% plot errorbar of ER, RL and SW networks
hold on;
tmpHorz = cellfun(@(x) x.HorzProp(3), randNetwork);
tmpVert = cellfun(@(x) x.VertProp(3), randNetwork);
hErr = ploterr(mean(tmpHorz), mean(tmpVert), std(tmpHorz), std(tmpVert), ...
    'abshhx', xErrBarWidth, 'abshhy', yErrBarWidth);
set(hErr, 'lineWidth', 2, 'Color', netColor('ER'));

tmpHorz = cellfun(@(x) x.HorzProp(3), regularRingNet);
tmpVert = cellfun(@(x) x.VertProp(3), regularRingNet);
hErr = ploterr(mean(tmpHorz), mean(tmpVert), std(tmpHorz), std(tmpVert), ...
    'abshhx', xErrBarWidth, 'abshhy', yErrBarWidth);
set(hErr, 'lineWidth', 2, 'Color', netColor('RL'));

tmpHorz = cellfun(@(x) x.HorzProp(3), smallRingNet);
tmpVert = cellfun(@(x) x.VertProp(3), smallRingNet);
hErr = ploterr(mean(tmpHorz), mean(tmpVert), std(tmpHorz), std(tmpVert), ...
    'abshhx', xErrBarWidth, 'abshhy', yErrBarWidth);
set(hErr, 'lineWidth', 2, 'Color', netColor('SW'));
hold off;

% annotation
text(double(ceNetwork.HorzProp(3)), double(ceNetwork.VertProp(3)), ...
    '   CE', 'FontSize', textSize, 'FontWeight', 'bold');
text(double(meanRandNet.HorzProp(3)), double(meanRandNet.VertProp(3)), ...
    '   ER', 'FontSize', textSize, 'FontWeight', 'bold');
text(double(meanRegularNet.HorzProp(3)), double(meanRegularNet.VertProp(3)), ...
    '   RL', 'FontSize', textSize, 'FontWeight', 'bold');
text(double(meanRingNet.HorzProp(3)), double(meanRingNet.VertProp(3)), ...
    '   SW', 'FontSize', textSize, 'FontWeight', 'bold');
text(double(cxNetwork.HorzProp(3)), double(cxNetwork.VertProp(3)), ...
    '   CX', 'FontSize', textSize, 'FontWeight', 'bold');
text(double(meanRingNet.HorzProp(3)), double(meanRingNet.VertProp(3)), ...
    '0.3\rightarrow   ', 'FontSize', textSize - 4, 'FontWeight', 'bold', ...
    'HorizontalAlignment', 'right');
text(double(meanSmallNet{3}.HorzProp(3)), double(meanSmallNet{3}.VertProp(3)), ...
    '0.05\rightarrow   ', 'FontSize', textSize - 4, 'FontWeight', 'bold', ...
    'HorizontalAlignment', 'right');
text(double(meanSmallNet{8}.HorzProp(3)), double(meanSmallNet{8}.VertProp(3)), ...
    '0.5\rightarrow   ', 'FontSize', textSize - 4, 'FontWeight', 'bold', ...
    'HorizontalAlignment', 'right');

breakYaxis(2);
set(gca, 'xtick', 0:0.2:1);