% This script produces the figure 7c. It plot the vertical propagation versus
% horizontal propagation of C. Elegans neural network, small-world network,
% random IO CE network, separated IO CE network, reversed IO CE network and
% distant IO SW network in level 2. The errorbar is standard deviation.

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

close all;

% plot setting
xErrBarWidth = 0.015;
yErrBarWidth = 0.015;
textSize = 16;
lineWidth = 3;
markerSize = 10;
markerScaleL = 1.5;
markerScaleS = 1.2;

FIG_SIZE = [0 0 600 650];
figure('name', 'summary', 'outerPosition', FIG_SIZE, 'color', 'w');

% plot marker of CE, rand IO CE, separated IO CE, reversed IO CE, distant IO SW
% and SW networks
hold on;
plot(ceNetwork.HorzProp(3), ceNetwork.VertProp(3), ...
    'Marker', netMarker('CE'), 'Color', netColor('CE'), ...
    'MarkerFaceColor', netMarkerFace('CE'), ...
    'MarkerSize', markerSize, 'LineWidth', lineWidth);
plot(meanRandIoCeNet.HorzProp(3), meanRandIoCeNet.VertProp(3), ...
    'Marker', netMarker('RandIoCE'), 'Color', netColor('RandIoCE'), ...
    'MarkerFaceColor', netMarkerFace('RandIoCE'), ...
    'MarkerSize', markerSize * markerScaleS, 'LineWidth', lineWidth);
plot(meanSepIoCeNet.HorzProp(3), meanSepIoCeNet.VertProp(3), ...
    'Marker', netMarker('SepIoCE'), 'Color', netColor('SepIoCE'), ...
    'MarkerFaceColor', netMarkerFace('SepIoCE'), ...
    'MarkerSize', markerSize * markerScaleL, 'LineWidth', lineWidth);
plot(revIoCeNet.HorzProp(3), revIoCeNet.VertProp(3), ...
    'Marker', netMarker('RevIoCE'), 'Color', netColor('RevIoCE'), ...
    'MarkerFaceColor', netMarkerFace('RevIoCE'), ...
    'MarkerSize', markerSize * markerScaleS, 'LineWidth', lineWidth);
plot(meanRingNet.HorzProp(3), meanRingNet.VertProp(3), ...
    'Marker', netMarker('SW'), 'Color', netColor('SW'), ...
    'MarkerFaceColor', netMarkerFace('SW'), ...
    'MarkerSize', markerSize, 'LineWidth', lineWidth);
plot(meanRingDistNet.HorzProp(3), meanRingDistNet.VertProp(3), ...
    'Marker', netMarker('DistSW'), 'Color', netColor('DistSW'), ...
    'MarkerFaceColor', netMarkerFace('DistSW'), ...
    'MarkerSize', markerSize, 'LineWidth', lineWidth);
set(gca, 'FontSize', 18, 'lineWidth', 4, 'FontWeight', 'bold');
xlabel('Horizontal propagation');
ylabel('Vertical propagation');
xlim([0, 1]);
ylim([0.4, 1]);
box off;

% plot errorbar of rand IO CE, separated IO CE, SW, distant IO SW networks
hold on;
tmpHorz = cellfun(@(x) x.HorzProp(3), randIoCeNet);
tmpVert = cellfun(@(x) x.VertProp(3), randIoCeNet);
hErr = ploterr(mean(tmpHorz), mean(tmpVert), std(tmpHorz), std(tmpVert), ...
    'abshhx', xErrBarWidth, 'abshhy', yErrBarWidth);
set(hErr, 'lineWidth', 2, 'Color', netColor('RandIoCE'));

tmpHorz = cellfun(@(x) x.HorzProp(3), sepIoCeNet);
tmpVert = cellfun(@(x) x.VertProp(3), sepIoCeNet);
hErr = ploterr(mean(tmpHorz), mean(tmpVert), std(tmpHorz), std(tmpVert), ...
    'abshhx', xErrBarWidth, 'abshhy', yErrBarWidth);
set(hErr, 'lineWidth', 2, 'Color', netColor('SepIoCE'));

tmpHorz = cellfun(@(x) x.HorzProp(3), smallRingNet);
tmpVert = cellfun(@(x) x.VertProp(3), smallRingNet);
hErr = ploterr(mean(tmpHorz), mean(tmpVert), std(tmpHorz), std(tmpVert), ...
    'abshhx', xErrBarWidth, 'abshhy', yErrBarWidth);
set(hErr, 'lineWidth', 2, 'Color', netColor('SW'));

tmpHorz = cellfun(@(x) x.HorzProp(3), smallRingDistNet);
tmpVert = cellfun(@(x) x.VertProp(3), smallRingDistNet);
hErr = ploterr(mean(tmpHorz), mean(tmpVert), std(tmpHorz), std(tmpVert), ...
    'abshhx', xErrBarWidth, 'abshhy', yErrBarWidth);
set(hErr, 'lineWidth', 2, 'Color', netColor('DistSW'));
hold off;

% plot the dash line of small-world networks with rewiring probability from
% 0.01 to 0.5 (defined in goAnalysis.m 'REWIRE')
hold on;
tmpVert = [meanRegularNet.VertProp(3), ...
    cellfun(@(x) x.VertProp(3), meanSmallNet(1:6)), ...
    meanRingNet.VertProp(3), ...
    cellfun(@(x) x.VertProp(3), meanSmallNet(7:end)), ...
    meanRandNet.VertProp(3)];
tmpHorz = [meanRegularNet.HorzProp(3), ...
    cellfun(@(x) x.HorzProp(3), meanSmallNet(1:6)), ...
    meanRingNet.HorzProp(3), ...
    cellfun(@(x) x.HorzProp(3), meanSmallNet(7:end)), ...
    meanRandNet.HorzProp(3)];
plot(tmpHorz, tmpVert, ':', 'lineWidth', 3, 'Color', netColor('SW'));
hold off;

% annotation
text(double(ceNetwork.HorzProp(3)), double(ceNetwork.VertProp(3)), ...
    '   CE', 'FontSize', textSize, 'FontWeight', 'bold');
text(double(meanRingNet.HorzProp(3)), double(meanRingNet.VertProp(3)), ...
    '   SW', 'FontSize', textSize, 'FontWeight', 'bold');
text(double(meanRandIoCeNet.HorzProp(3)), double(meanRandIoCeNet.VertProp(3)), ...
    {'   Random', '   I/O CE'}, 'FontSize', textSize, 'FontWeight', 'bold', ...
    'VerticalAlignment', 'bottom');
text(double(meanSepIoCeNet.HorzProp(3)), double(meanSepIoCeNet.VertProp(3)), ...
    {'Separated  ', 'I/O CE  '}, 'FontSize', textSize, 'FontWeight', 'bold', ...
    'VerticalAlignment', 'bottom', 'HorizontalAlignment', 'right');
text(double(revIoCeNet.HorzProp(3)), double(revIoCeNet.VertProp(3)), ...
    {'  Reversed', '  I/O CE'}, 'FontSize', textSize, 'FontWeight', 'bold', ...
    'VerticalAlignment', 'top');
text(double(meanRingDistNet.HorzProp(3)), double(meanRingDistNet.VertProp(3) - 0.02), ...
    {'Distant', 'I/O SW'}, 'FontSize', textSize, 'FontWeight', 'bold', ...
    'VerticalAlignment', 'top', 'HorizontalAlignment', 'center');

breakYaxis(2);
set(gca, 'xtick', 0:0.2:1);