% This script generate figure 8a. This script in not only a plotting script but
% also an anlaysis script. It contain the process of inserting 3 kinds of hubs
% into small-world networks (provinical, connnector and kinless hubs), so it
% may take several minutes to analyse and plot vertical versus horizontal
% propagation in level 2.

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

close all;

% setting of analysis
nNode = ceNetwork.size;
nInput = ceNetwork.inputNumber;
nOutput = ceNetwork.outputNumber;
nInter = ceNetwork.size - nInput - nOutput;
nEdge = mean(sum(ceNetwork.matrix));
repeatTimes = 100;
nHub = 15;
rewireProb = 0.3;
hubStyleSet = {'Provincial', 'Connector', 'Kinless'};

% setting of plot
xErrBarWidth = 0.015;
yErrBarWidth = 0.025;
textSize = 16;
lineWidth = 3;
markerSize = 10;
markerScale = 1.5;

% plot marker of CE, ER, RL, SW networks
FIG_SIZE = [0 0 600 650];
figure('name', 'summary', 'outerPosition', FIG_SIZE, 'color', 'w');
hold on;
plot(ceNetwork.HorzProp(3), ceNetwork.VertProp(3), ...
    'Marker', netMarker('CE'), 'Color', netColor('CE'), ...
    'MarkerFaceColor', netMarkerFace('CE'), ...
    'MarkerSize', markerSize, 'LineWidth', lineWidth);
plot(meanRandNet.HorzProp(3), meanRandNet.VertProp(3), ...
    'Marker', netMarker('ER'), 'Color', netColor('ER'), ...
    'MarkerFaceColor', netMarkerFace('ER'), ...
    'MarkerSize', markerSize * markerScale, 'LineWidth', lineWidth);
plot(meanRegularNet.HorzProp(3), meanRegularNet.VertProp(3), ...
    'Marker', netMarker('RL'), 'Color', netColor('RL'), ...
    'MarkerFaceColor', netMarkerFace('RL'), ...
    'MarkerSize', markerSize, 'LineWidth', lineWidth);
plot(meanRingNet.HorzProp(3), meanRingNet.VertProp(3), ...
    'Marker', netMarker('SW'), 'Color', netColor('SW'), ...
    'MarkerFaceColor', netMarkerFace('SW'), ...
    'MarkerSize', markerSize, 'LineWidth', lineWidth);
set(gca, 'FontSize', 18, 'lineWidth', 4, 'FontWeight', 'bold');
legend('boxoff');
xlabel('Horizontal propagation');
ylabel('Vertical propagation');
box off;

% generate and analyse provinical, connnector, kinless hubs SW networks
meanSwHubNet = cell(1, numel(hubStyleSet));
for jStype = 1:numel(hubStyleSet)
    hubStyle = hubStyleSet{jStype};
    clear swHubNet meanswHubNet
    for iTime = 1:repeatTimes
        seedNumber = iTime * STRIDE_SEED_NUMBER;
        swHubNet{iTime} = ...
            smallHubNetwork(nNode, rewireProb, seedNumber, nEdge, nHub, hubStyle);
        swHubNet{iTime} = setIO(swHubNet{iTime}, ceNetwork.inputNumber, ...
            ceNetwork.outputNumber);
        swHubNet{iTime} = levelAnalysis(swHubNet{iTime}, MAX_LEVEL);
    end
    tmpHorz = cellfun(@(x) x.HorzProp(3), swHubNet);
    tmpVert = cellfun(@(x) x.VertProp(3), swHubNet);
    meanSwHubNet{jStype} = meanFieldInCells(swHubNet);
    meanSwHubNet{jStype}.StdHorzProp = std(tmpHorz);
    meanSwHubNet{jStype}.StdVertProp = std(tmpVert);
    smallHubNet{jStype} = swHubNet;
end

% plot marker of provinical, connnector and kinless hubs SW networks
hold on;
for iStyle = 1:numel(hubStyleSet)
    thisStyle = hubStyleSet{iStyle};
    if netMarker(thisStyle) == '+' || netMarker(thisStyle) == 'x'
        tmpMarkerSize = markerSize * markerScale;
    else
        tmpMarkerSize = markerSize;
    end

    plot(meanSwHubNet{iStyle}.HorzProp(3), ...
        meanSwHubNet{iStyle}.VertProp(3), ...
        'Marker', netMarker(thisStyle), 'Color', netColor(thisStyle), ...
        'MarkerFaceColor', netMarkerFace(thisStyle), ...
        'MarkerSize', tmpMarkerSize, 'LineWidth', lineWidth);
end
hold off;

% plot error bar of ER, RL, SW and 3 kinds of hubs SW networks
hold on;
tmpHorz = cellfun(@(x) x.HorzProp(3), randNetwork);
tmpVert = cellfun(@(x) x.VertProp(3), randNetwork);
hErr = ploterr(mean(tmpHorz), mean(tmpVert), std(tmpHorz), std(tmpVert), ...
    'abshhx', xErrBarWidth, 'abshhy', yErrBarWidth);
set(hErr, 'lineWidth', 2, 'Color', netColor('ER'));

tmpHorz = cellfun(@(x) x.HorzProp(3), regularRingNet);
tmpVert = cellfun(@(x) x.VertProp(3), regularRingNet);
hErr = ploterr(mean(tmpHorz), mean(tmpVert), std(tmpHorz), std(tmpVert), ...
    'abshhx', xErrBarWidth, 'abshhy', yErrBarWidth);
set(hErr, 'lineWidth', 2, 'Color', netColor('RL'));

tmpHorz = cellfun(@(x) x.HorzProp(3), smallRingNet);
tmpVert = cellfun(@(x) x.VertProp(3), smallRingNet);
hErr = ploterr(mean(tmpHorz), mean(tmpVert), std(tmpHorz), std(tmpVert), ...
    'abshhx', xErrBarWidth, 'abshhy', yErrBarWidth);
set(hErr, 'lineWidth', 2, 'Color', netColor('SW'));

for iStyle = 1:numel(hubStyleSet)
    hErr = ploterr(meanSwHubNet{iStyle}.HorzProp(3), ...
        meanSwHubNet{iStyle}.VertProp(3), ...
        meanSwHubNet{iStyle}.StdHorzProp, ...
        meanSwHubNet{iStyle}.StdVertProp, ...
        'abshhx', xErrBarWidth, 'abshhy', yErrBarWidth);
    set(hErr, 'lineWidth', 2, 'Color', netColor(hubStyleSet{iStyle}));
end

% plot dash line from SW networks to hubs SW networks
for iStyle = 1:numel(hubStyleSet)
    plot([meanRingNet.HorzProp(3) meanSwHubNet{iStyle}.HorzProp(3)], ...
        [meanRingNet.VertProp(3) meanSwHubNet{iStyle}.VertProp(3)], ...
        '--', 'lineWidth', 2, 'Color', netColor(hubStyleSet{iStyle}));
end
hold off;

% annotation
text(double(ceNetwork.HorzProp(3)), double(ceNetwork.VertProp(3) + 0.02), ...
    'CE', 'FontSize', textSize, 'FontWeight', 'bold', ...
    'VerticalAlignment', 'bottom', 'HorizontalAlignment', 'center');
text(double(meanRandNet.HorzProp(3)), double(meanRandNet.VertProp(3)), ...
    '   ER', 'FontSize', textSize, 'FontWeight', 'bold');
text(double(meanRegularNet.HorzProp(3)), double(meanRegularNet.VertProp(3)), ...
    '   RL', 'FontSize', textSize, 'FontWeight', 'bold');
text(double(meanRingNet.HorzProp(3)), double(meanRingNet.VertProp(3)), ...
    'SW   ', 'FontSize', textSize, 'FontWeight', 'bold', ...
    'HorizontalAlignment', 'right');
text(double(meanSwHubNet{1}.HorzProp(3)), double(meanSwHubNet{1}.VertProp(3)), ...
    'Provincial  ', 'FontSize', textSize, 'FontWeight', 'bold', ...
    'HorizontalAlignment', 'right');
text(double(meanSwHubNet{2}.HorzProp(3)), double(meanSwHubNet{2}.VertProp(3)), ...
    ' Connector', 'FontSize', textSize, 'FontWeight', 'bold', ...
    'VerticalAlignment', 'top');
text(double(meanSwHubNet{3}.HorzProp(3)), double(meanSwHubNet{3}.VertProp(3) - 0.02), ...
    'Kinless', 'FontSize', textSize, 'FontWeight', 'bold', ...
    'VerticalAlignment', 'top', 'HorizontalAlignment', 'center');

breakYaxis(2);
set(gca, 'xtick', 0:0.2:1);