% This script produces the figure 7a. It plot the vertical propagation versus
% propagation levels in C. Elegans network, rand IO CE networks, separated IO
% CE networks, reversed IO CE network, small-world network, distant IO SW
% network. The curves are based on fitting Gompertz function. The errorbar is
% standard deviation.

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

close all;

% plot setting
FIG_SIZE = [0 0 1200 600];
lineWidth = 3;
markerSize = 10;
markerScaleL = 1.5;
markerScaleS = 1.2;

% fitting with Gompertz function
cfit.CE = fitGompertz(0:(MAX_LEVEL - 2), ceNetwork.VertProp);
cfit.RingDist = fitGompertz(0:(MAX_LEVEL - 2), meanRingDistNet.VertProp);
cfit.Ring = fitGompertz(0:(MAX_LEVEL - 2), meanRingNet.VertProp);
cfit.RandIoCE = fitGompertz(0:(MAX_LEVEL - 2), meanRandIoCeNet.VertProp);
cfit.SepIoCE = fitGompertz(0:(MAX_LEVEL - 2), meanSepIoCeNet.VertProp);
cfit.RevIoCe = fitGompertz(0:(MAX_LEVEL - 2), revIoCeNet.VertProp);

% save cfit object to each network
ceNetwork.cfitVertProp = cfit.CE;
meanRingDistNet.cfitVertProp = cfit.RingDist;
meanRingNet.cfitVertProp = cfit.Ring;
meanRandIoCeNet.cfitVertProp = cfit.RandIoCE;
meanSepIoCeNet.cfitVertProp = cfit.SepIoCE;
revIoCeNet.cfitVertProp = cfit.RevIoCe;

% plot marker and errorbar of each networks
figure('name', 'Vertical Propagation', 'outerPosition', FIG_SIZE, 'color', 'w');
hold on;
tmpP = linspace(0, MAX_LEVEL - 2, 100);
plot(0:(MAX_LEVEL - 2), ceNetwork.VertProp, 'Marker', netMarker('CE'), ...
    'Color', netColor('CE'), 'MarkerSize', markerSize, ...
    'MarkerFaceColor', netMarkerFace('CE'), ...
    'LineWidth', lineWidth, 'LineStyle', 'none');
errorbar(0:(MAX_LEVEL - 2), meanRandIoCeNet.VertProp, ...
    stdRandIoCeNet.VertProp, 'Marker', netMarker('RandIoCE'), ...
    'Color', netColor('RandIoCE'), 'MarkerSize', markerSize * markerScaleS, ...
    'MarkerFaceColor', netMarkerFace('RandIoCE'), ...
    'LineWidth', lineWidth, 'LineStyle', 'none');
errorbar(0:(MAX_LEVEL - 2), meanSepIoCeNet.VertProp, ...
    stdSepIoCeNet.VertProp, 'Marker', netMarker('SepIoCE'), ...
    'Color', netColor('SepIoCE'), 'MarkerSize', markerSize * markerScaleL, ...
    'MarkerFaceColor', netMarkerFace('SepIoCE'), ...
    'LineWidth', lineWidth, 'LineStyle', 'none');
plot(0:(MAX_LEVEL - 2), revIoCeNet.VertProp, ...
    'Marker', netMarker('RevIoCE'), 'Color', netColor('RevIoCE'), ...
    'MarkerSize', markerSize * markerScaleS, ...
    'MarkerFaceColor', netMarkerFace('RevIoCE'), ...
    'LineWidth', lineWidth, 'LineStyle', 'none');
errorbar(0:(MAX_LEVEL - 2), meanRingNet.VertProp, ...
    stdRingNet.VertProp, 'Marker', netMarker('SW'), ...
    'Color', netColor('SW'), 'MarkerSize', markerSize, ...
    'MarkerFaceColor', netMarkerFace('SW'), ...
    'LineWidth', lineWidth, 'LineStyle', 'none');
errorbar(0:(MAX_LEVEL - 2), meanRingDistNet.VertProp, ...
    stdRingDistNet.VertProp, 'Marker', netMarker('DistSW'), ...
    'Color', netColor('DistSW'), 'MarkerSize', markerSize, ...
    'MarkerFaceColor', netMarkerFace('DistSW'), 'LineWidth', lineWidth, ...
    'LineStyle', 'none');

% plot fitting curve of each network
plot(tmpP, cfit.CE(tmpP), 'Color', netColor('CE'), 'LineWidth', 4);
plot(tmpP, cfit.RandIoCE(tmpP), 'Color', netColor('RandIoCE'), 'LineWidth', 4);
plot(tmpP, cfit.SepIoCE(tmpP), 'Color', netColor('SepIoCE'), 'LineWidth', 4);
plot(tmpP, cfit.RevIoCe(tmpP), 'Color', netColor('RevIoCE'), 'LineWidth', 4);
plot(tmpP, cfit.Ring(tmpP), 'Color', netColor('SW'), 'LineWidth', 4);
plot(tmpP, cfit.RingDist(tmpP), 'Color', netColor('DistSW'), 'LineWidth', 4);
plot([2 2], [0 meanRandIoCeNet.cfitVertProp(2)], '--k', 'lineWidth', 3);
set(gca, 'FontSize', 18, 'lineWidth', 4, 'FontWeight', 'bold');

hL = legend('CE', 'Random I/O CE', 'Separated I/O CE', 'Reversed I/O CE', ...
    'SW', 'Distant I/O SW', 'location', 'southEast');
legend(gca, 'boxoff');
% to show the correct linewidth of errorbar's symbol due to matlab's bug
set(findobj(hL, 'type', 'line'), 'LineWidth', lineWidth);

xlim([0 4]);
ylim([0 1.1]);
xlabel('Propagation level');
ylabel('Vertical propagation');
set(gca, 'xTick', [0 1 2 3 4], 'yTick', [0 0.4 0.8 1]);
box off;