function [ status ] = loadStruct( structure, workspaceName )
% LOADSTRUCT load each field of structure and save them to specified workspace.
%
%   [ status ] = loadStruct( structure )
%   This function load each field of structure and save them to specified
%   workspace with each field name as variable name. Default workspaceName
%   is 'base'.
%
%   Input:
%       structure: a struct variable
%       workspaceName: 'base' workspace or 'caller' workspace
%
%   Output:
%       status: represent success or not (true -> success, [] -> fail)

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

if nargin < 2
    workspaceName = 'base';
end

fieldName = fieldnames(structure);
for iName = 1:numel(fieldName)
    variableName = fieldName{iName};
    % check this variable name exist in specified workspace or not
    isExistName = evalin(workspaceName, ...
        ['exist(''', variableName, ''', ''var'');']);
    if isExistName
        error(['Already exist a variable named as ''', variableName, '''.']);
    end
    variableContent = getfield(structure, variableName);
    assignin(workspaceName, variableName, variableContent);
end
status = true;
end
