function [ corrCoefList ] = logCorrCoef( network )
% LOGCORRCOEF compute vertical propagation of network
%
%   [ corrCoefList ] = logCorrCoef( network )
%   This function compute correlation coefficient of channel connectivity
%   matrixes between adjacent levels in input network.
%
%   Input:
%       network: a network structure containing ChConnectMat field
%
%   Output:
%       corrCoefList: correlation coefficient between adjacent levels

%    ---------
%    Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

nLevel = numel(network.ChConnectMat);
for iLevel = 1:(nLevel - 1)
    thisLevelChMat = full(network.ChConnectMat{iLevel});
    nextLevelChMat = full(network.ChConnectMat{iLevel + 1});
    tmpCorrCoef = corrcoef(thisLevelChMat(:), nextLevelChMat(:));
    corrCoefList(iLevel) = tmpCorrCoef(1, 2);
end
end