function [ chConnectMat ] = logMatrix( nPathMat, smallValue )
% LOGMATRIX return logarithm of pathway number matrix adding a small value
%
%   [ chConnectMat ] = logMatrix( nPathMat, smallValue )
%   This function return logarithm of pathway number matrix adding a small
%   value to prevent log10(0). The result is channel connectivity matrix.
%
%   Input:
%       nPathMat: pathway number matrix
%       smallValue: small value to prevent log10(0), and default value is 0.1.
%
%   Ouptut:
%       chConnectMat: channel connectivity matrix

%    ---------
%    Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

if ~exist('smallValue', 'var')
    smallValue = 0.1;
end
chConnectMat = log10(nPathMat + smallValue);
end
