function [ hImage ] = myImagesc( matrix, plotOpt )
% MYIMAGESC plot imagesc() with compact layout
%
%   [ hImage ] = myImagesc( matrix, plotOpt )
%   myImagesc() plot imagesc() with compact layout.
%
%   Input:
%       matrix: matrix to plot
%       plotOpt: plot option
%           plotOpt.showXTick == false, no tick label on x-axis
%           plotOpt.showYTick == false, no tick label on y-axis
%
%   Output:
%       hImage: handle of plot

%    ---------
%    Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

[nRow, nCol] = size(matrix);
hImage = imagesc(matrix);
colorbar;
axis equal;
xlim([0.5, nCol + 0.5]);
ylim([0.5, nRow + 0.5]);
if plotOpt.showXTick == false
    set(gca, 'xTick', []);
end
if plotOpt.showYTick == false
    set(gca, 'yTick', []);
end
set(gca, 'fontName', 'Arial');
end