function [ c ] = netColor( networkName )
% NETCOLOR return specific color corresponding network

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

switch networkName
    case 'CE'
        c = [1, 0, 0];
    case 'CX'
        c = [1, 0, 1];
    case 'RL'
        c = [0, 1, 0];
    case 'SW'
        c = [0, 0, 1];
    case 'ER'
        c = [0.95, 0.95, 0];
    case 'RandIoCE'
        c = [0.95, 0.95, 0];
    case 'SepIoCE'
        c = [0, 1, 0];
    case 'RevIoCE'
        c = [1, 0, 1];
    case 'DistSW'
        c = [0, 1, 1];
    case 'Provincial'
        c = [0, 0, 1];
    case 'Connector'
        c = [0, 0, 1];
    case 'Kinless'
        c = [0, 0, 1];
    otherwise
        error('No match networkName');
end