function [ m ] = netMarker( networkName )
% NETMARK return specific symbol with corresponding network

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

switch networkName
    case 'CE'
        m = '^';
    case 'CX'
        m = 'x';
    case 'RL'
        m = 'd';
    case 'SW'
        m = 'o';
    case 'ER'
        m = '+';
    case 'RandIoCE'
        m = 's';
    case 'SepIoCE'
        m = '+';
    case 'RevIoCE'
        m = 's';
    case 'DistSW'
        m = 'd';
    case 'Provincial'
        m = '^';
    case 'Connector'
        m = 'x';
    case 'Kinless'
        m = 'o';
    otherwise
        error('No match networkName');
end
