function [ parCoef ] = participateCoef( network )
% PARTICIPATECOEF compute modified participate coefficient of network
%
%   [ parCoef ] = participateCoef( network )
%   This function compute modified participate coefficient (normalize output of
%   the coefficient to [0, 1]) of each nodes in network.
%
%   Input:
%       network: input network which has been sorted by module (sortByModule())
%
%   Output:
%       parCoef: participate coefficient of nodes in input network

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

moduleList = unique(network.moduleId);
nModule = numel(moduleList);
nNode = network.size;
parCoef = zeros(1, nNode);
tmpMat = network.matrix;
for iNode = 1:nNode
    tmpCoef = [];
    tmpSumDeg = numel(find(tmpMat(:, iNode))) + numel(find(tmpMat(iNode, :)));
    for jModule = moduleList
        tmpModuleIx = find(network.moduleId == jModule);
        tmpModuleLink = numel(find(tmpMat(tmpModuleIx, iNode))) + ...
            numel(find(tmpMat(iNode, tmpModuleIx)));
        tmpCoef(jModule) = (tmpModuleLink / tmpSumDeg) ^ 2;
    end

    % normalize participate coefficient to [0, 1]
    parCoef(iNode) = (1 - sum(tmpCoef)) * (nModule / (nModule - 1));
end
end
