function [ probDens, xout ] = probDensity( y, nBins )
% PROBDENSITY return probability density and xout for plot
%
%   [ probDens, xout ] = probDensity( y, nBins )
%   probDensity() compute probability density of y in each bin and return xout
%   as center of each bin.

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

binSize = (max(y(:)) - min(y(:))) / nBins;
nElement = numel(y);
[count, xout] = hist(y(:), nBins);
prob = count / nElement;
probDens = prob / binSize;
end
