function [ network ] = randomNetwork( number, probability, seedNumber )
% RANDNETWORK generate random networks by input number, probability, seedNumber
%
%   [ network ] = randomNetwork( number, probability, seedNumber )
%   This function generate random network by input number, probability and
%   seedNumber.
%
%   Input:
%       number: number of nodes
%       probability: connection probability
%       seedNumber: seed number of random number generator
%
%   Output:
%       network: rand network

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

network = struct('size', number, 'probability', probability, 'seed', seedNumber);
rand('seed', seedNumber);
network.matrix = sparse(number, number);
for row = 1:number
    for col = 1:number
        if row == col
            continue;
        end
        if rand() <= probability
            network.matrix(row, col) = 1;
        end
    end
end
network.label = 1:number;
end
