function [ network ] = readLabel( network, filePath )
% READLABEL load neuron labels from filePath and assign them to network
%
%   [ network ] = readLabel( network, filePath )
%   This function load neuron labels from filePath and assign them to network
%
%   Input:
%       network: a network structure
%       filePath: path of neuron label file that contain which nodes are input
%           neurons, which are output neurons and which are inter neurons
%
%   Output:
%       network: a network structure

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

countLine = 1;
fileID = fopen(filePath, 'r');
while ~feof(fileID)
    strLine = fgetl(fileID);
    if strLine(1) == '#'
        continue;
    % if label is using number to represent
    elseif ~isempty( regexp(strLine(1), '[0-9]') )
        numericLine = strread(strLine, '%d');
    % if label is using string to represent
    elseif isempty( regexp(strLine(1), '[0-9]') )
        numericLine = strread(strLine, '%s');
    end
    numericLine = numericLine';
    switch countLine
    case 1
        network.label = numericLine;
    case 2
        network.inputList = numericLine;
    case 3
        network.outputList = numericLine;
    end
    countLine = countLine + 1;
end
fclose(fileID);
end

