function [ rmNetwork ] = rmNode( network, rmIx )
% RMNODE remove node with index rmIx of network
%
%   [ rmNetwork ] = rmNode( network, rmIx )
%   This function remove specific node by index rmIx in network
%
%   Input:
%       network: network structure
%       rmIx: index of removing node
%
%   Output:
%       rmNetwork: network after removing node

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

network.matrix(rmIx, :) = [];
network.matrix(:, rmIx) = [];
network.size = network.size - numel(rmIx);
rmLabel = network.label(rmIx);
network.label(rmIx) = [];
network.moduleId(rmIx) = [];
for iLabel = rmLabel
    if ~isempty(find(network.inputList == iLabel, 1))
        tmpIx = find(network.inputList == iLabel, 1);
        network.inputList(tmpIx) = [];
        network.inputNumber = network.inputNumber - 1;
    elseif ~isempty(find(network.outputList == iLabel, 1))
        tmpIx = find(network.outputList == iLabel, 1);
        network.outputList(tmpIx) = [];
        network.outputNumber = network.outputNumber - 1;
    end
end
rmNetwork = network;
end
