function [ pathRatioVector ] = rowPathRatio( connectMatrix )
% ROWPATHRATIO compute horizontal propagation of connection matrix
%
%   [ pathRatioVector ] = rowPathRatio( connectMatrix )
%   This function compute percentage of how many input-output pathway has been
%   established in this connection matrix.
%
%   Input:
%       connectMatrix: a matrix which row is input nodes and column is output
%           nodes. Each elements is pathway number between input and output
%           nodes.
%
%   Output:
%       pathRatioVector: a vector, in which element is percentage of how many
%       input-output pathway has been established

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

connectMatrix = full(connectMatrix);
[nRow, nCol] = size(connectMatrix);
pathRatioVector = zeros(1, nRow);
for iRow = 1:nRow
    connectIx = find(connectMatrix(iRow, :) > 0);
    pathRatioVector(iRow) = numel(connectIx) / nCol;
end
end
