function [ network ] = sortByModule( network )
% SORTBYMODULE sort all types of nodes in order of modules.
%
%   [ network ] = sortByModule( network )
%   This function will find community structures of all nodes, and arrange
%   each type of nodes in order of its module. Finally nodes will be arraged
%   by its type (input, output, inter) and its module id.
%
%   Input:
%       network: a network structure contain input & output nodes information.
%
%   Output:
%       network: a network structure sorted in order of modules.

%   ---------
%   Yen-Nan Lin, NTHU, 2010-2014, Matlab 2012a

FIELD_NAME_MODULE_ID = 'moduleId';

% find community structure by brain connectivity toolbox
moduleIdEachNode = modularity_dir(full(network.matrix));

inputIx = findList(network.label, network.inputList);
outputIx = findList(network.label, network.outputList);
interList = setdiff(network.label, [network.inputList, network.outputList]);
interIx = findList(network.label, interList);
% rearrage index by modules
[sortInputModuleId, sortInputIx] = sort(moduleIdEachNode(inputIx), 'ascend');
[sortOutputModuleId, sortOutputIx] = sort(moduleIdEachNode(outputIx), 'ascend');
[sortInterModuleId, sortInterIx] = sort(moduleIdEachNode(interIx), 'ascend');
sortAllIx = [inputIx(sortInputIx), outputIx(sortOutputIx), ...
    interIx(sortInterIx)];
sortAllModuleId = ([sortInputModuleId; sortOutputModuleId; sortInterModuleId]');

network.label = network.label(sortAllIx);
network.matrix = network.matrix(sortAllIx, sortAllIx);
network = setfield(network, FIELD_NAME_MODULE_ID, sortAllModuleId);
end

function [ indexList ] = findList( array, wantedList )
indexList = [];
nEntry = numel(array);
for iEntry = 1:nEntry
    if ~isempty(find(wantedList == array(iEntry), 1))
        indexList = [indexList, iEntry];
    end
end
end
